#===================================================================
#
#   Copyright 1991 IBM Corporation
#
#===================================================================

!include ..\toolkit.inc

SVR_HEADERS = svrqmain.h svrqxtrn.h svrqglbl.h svrqhelp.h queue.h
CLI_HEADERS = cliqmain.h cliqxtrn.h cliqglbl.h cliqhelp.h queue.h


#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

SVR_OBJ = svrqmain.obj svrqthrd.obj svrqpnt.obj svrqhelp.obj
CLI_OBJ = cliqmain.obj cliqthrd.obj cliqhelp.obj


#-------------------------------------------------------------------
#   A list of all of the Help text files
#-------------------------------------------------------------------

SVR_IPF = svrqueue.ipf file.ipf svroptn.ipf help.ipf dlg.ipf
CLI_IPF = cliqueue.ipf file.ipf clientry.ipf help.ipf dlg.ipf


#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------

all: svrqueue.exe svrqueue.hlp cliqueue.exe cliqueue.hlp .symbolic
    @%null

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

svrqmain.res: svrqmain.rc queue.ico svrqmain.h svrqhelp.rc svrqhelp.h

svrqmain.obj: svrqmain.c $(SVR_HEADERS)

svrqthrd.obj: svrqthrd.c $(SVR_HEADERS)

svrqpnt.obj:  svrqpnt.c  $(SVR_HEADERS)

svrqhelp.obj: svrqhelp.c $(SVR_HEADERS)


cliqmain.res: cliqmain.rc queue.ico cliqmain.h cliqhelp.rc cliqhelp.h

cliqmain.obj: cliqmain.c $(CLI_HEADERS)

cliqthrd.obj: cliqthrd.c $(CLI_HEADERS)

cliqhelp.obj: cliqhelp.c $(CLI_HEADERS)


#-------------------------------------------------------------------
#   This section creates the help manager file.  The IPF compiler
#   creates a file called main.hlp which is renamed to template.hlp.
#-------------------------------------------------------------------

svrqueue.hlp: $(SVR_IPF)
cliqueue.hlp: $(CLI_IPF)


#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

svrqueue.exe: $(SVR_OBJ) svrqueue.lnk svrqueue.res
    $(LINK) @svrqueue.lnk
    rc -p -x svrqueue.res svrqueue.exe


cliqueue.exe: $(CLI_OBJ) cliqueue.lnk cliqueue.res
    $(LINK) @cliqueue.lnk
    rc -p -x cliqueue.res cliqueue.exe
